/**
 * @param {*} obj           //上傳的物件
 * @param {*} maxSize       //上傳檔案容量上限
 * @param {*} minWidth      //上傳檔案寬度下限
 * @param {*} imgPreArea    //預覽影像img所在的區域
 * @param {*} uploadErrMsg  //上傳錯誤訊息顯示的區域
 * @param {*} issubmit      //檢查是否可以過關是否可送出表單
 * @param {*} errMsg        //上傳有錯的訊息
 */

function upload_chk_img(obj, maxSize, minWidth, imgPreArea, uploadErrMsg) {
  //console.log(obj);
  //清除還原預設
  //let result;
  issubmit = true;
  errMsg = '';
  uploadErrMsg.innerHTML = '';
  imgPreArea.src = '';

  //建立檔案讀取器物件 > 預覽圖片 > 檢查容量
  let fileReader = new FileReader();
  //因為讀取器的建立與整頁的讀取非同步進行, 所以得等待onload之後再檢查
  fileReader.onload = function (e) {
    //e.target.result 也就是讀取器接收到的檔案名稱資訊
    let data = e.target.result;
    //console.log(data);
    //預覽影像
    imgPreArea.src = data;
    //檢查容量
    if (maxSize < obj['size']) {
      issubmit = false;
      errMsg += '容量太大!!!!';
    }
    //建立影像物件 > 檢查寬度
    let imgReader = new Image();
    imgReader.onload = function () {
      let upfileWidth = imgReader.width;
      if (upfileWidth < minWidth) {
        issubmit = false;
        errMsg += ' 寬度太小!!!!';
      }
      
      uploadErrMsg.innerHTML = errMsg;
      
    }
    imgReader.src = data;
  }
  fileReader.readAsDataURL(obj);
}
