<!DOCTYPE html>
<html lang="zh-Hant-TW">

<head>
  <?php include('../TS_webpage/head.php'); ?>
  <style>
    .cart-list div {
      display: flex;
      align-items: center;
      white-space: nowrap;
    }

    form .form-control {
      font-size: 18px;
    }

    .updatememBtn:hover {
      background-color: #000;
    }

    .chkoutBtn {
      font-size: 18px;
      font-weight: bold;
      margin-right: 10px;
      padding: 5px 15px;
    }

    .chkoutBtn .bi,
    .chkoutBtn img {
      margin-right: 5px;
    }

    .btn-card {
      background-color: #f9e65b;
      color: #000;
      display: flex;
      align-items: center;
    }

    .btn-card:hover {
      background-color: #ffc71c;
      color: #000;
    }

    .btn-line {
      background-color: #0dc05e;
      color: #fff;
      display: flex;
      align-items: center;
    }

    .btn-line:hover {
      background-color: #09803e;
      color: #fff;
    }

    .btn-cash {
      background-color: #96e9fa;
      color: #000;
      display: flex;
      align-items: center;
    }

    .btn-cash:hover {
      background-color: #22cff4;
      color: #000;
    }

    .btn-chkout {
      background-color: #e25866;
      color: #fff;
      display: flex;
      align-items: center;
    }

    .btn-chkout:hover {
      background-color: #8f1824;
      color: #fff;
    }
  </style>
</head>

<body data-no="3">

  <?php include('../TS_webpage/header.php'); ?>

  <main>
    
      <div class="container-xl">
        <h3><i class="bi bi-receipt-cutoff"></i> 商品清單
          <a href="javascript:;" class="switch-show-shoplist fs-5 fw-bold d-inline-flex align-items-center" style="transform: translateY(-5px);">
            【<i class="bi bi-eye"></i>展開】
          </a>
        </h3>

        <div id="prod-list" class="cart-list d-none">

          <!-- 商品清單的欄標題 -->
          <div class="p-2" style="background-color: #fff; border-bottom: 4px double #999">
            <div style="flex:0 0 50px">商品縮圖</div>
            <div class="row" style="flex:1">
              <div class="col-12 col-md-6 flex-md-fill">商品名稱 [顏色] [尺寸]</div>
              <div class="col-6 col-md-2 justify-content-md-end">價格</div>
              <div class="col-6 col-md-2 justify-content-md-end">數量</div>
              <div class="col-6 col-md-2 justify-content-md-end">小計</div>
            </div>
          </div>

          <!-- 商品清單列表 -->
          

            <div class="d-flex p-1" style="border-bottom: 1px solid #ccc">
              <!-- 圖片 -->
              <div style="flex:0 0 50px">

                <img src="../img_layout/pre_img_prod.png" alt="" class="d-block w-100 rounded">

              </div>
              <div class="row prod-item" style="flex:1">
                <!-- 商品名稱 -->
                <div class="col-12 col-md-6 flex-md-fill">
                  <a href="./shop_detail.php" target="_blank">
                    [id] name
                    [class_color_name]
                    [class_size_name]
                  </a>
                </div>
                <!-- 價格 -->
                <div class="col-6 col-md-2 justify-content-md-end">
                  NT$9,999
                </div>

                <!-- 數量 -->
                <div class="col-6 col-md-2 justify-content-end position-relative">
                  9
                </div>

                <!-- 小計 -->
                <div class="col-6 col-md-2 justify-content-md-end sub-total">
                  NT$9,999
                </div>
              </div>
            </div>

          

          <!-- 總金額 -->
          <div class="d-block fs-3 text-end" style="border-top: 4px double #999;">合計總金額：NT$9,999</div>

        </div>

        <h3 class="mt-5"><i class="bi bi-file-earmark-person"></i> 收貨人資訊</h3>

        <form id="mem-info-form" action="" method="post" class="py-2" style="font-size: 18px;">
          <div class="row">
            <div class="col-12 col-md-9">

              <div class="d-flex align-items-center mb-3">
                <div class="text-end" style="flex:0 0 6rem">姓名：</div>
                <div class="d-block w-100">
                  <input type="text" id="shop_name" name="shop_name" maxlength="20" value="" class="form-control" placeholder="請輸入收貨人的姓名...">
                </div>
              </div>

              <div class="d-flex align-items-center mb-3">
                <div class="text-end" style="flex:0 0 6rem">電話：</div>
                <div class="d-block w-100">
                  <input type="text" id="shop_phone" name="shop_phone" maxlength="20" value="" class="form-control" placeholder="請輸入收貨人的聯絡電話/手機...">
                </div>
              </div>

              <div class="d-flex align-items-center mb-3">
                <div class="text-end" style="flex:0 0 6rem">地址：</div>
                <div class="d-block w-100">
                  <input type="text" id="shop_address" name="shop_address" maxlength="100" value="" class="form-control" placeholder="請輸入收貨的詳細地址...">
                </div>
              </div>

              <div class="ms-5 mt-2 p-2 border" style="display: block; color: #444; background-color:#f5f5f5; opacity:.5">
                <p>這個區域原則上是隱藏的, 顯示是為了檢示及了解 ~~~~~~~~~~~~~~~~~~~~ </p>
                <!-- 以下應該是type="hidden" =================================================== -->
                <span>會員ID：<input type="text" id="mem_id" name="mem_id" value="" readonly ></span>
                <span>總 價：<input type="text" name="shop_total" value="" readonly ></span><br>
                <span>商品ID：<input type="text" name="prod_size_id" value="" readonly ></span>
                <span>數 量：<input type="text" name="prod_count" value="" readonly ></span>
                <span>單 價：<input type="text" name="shop_price" value="" readonly ></span>
              </div>

            </div>

            <div class="col-12 col-md-3 d-flex flex-column align-items-center justify-content-end">
              <a href="javascript:;" onclick="window.history.back()" class="btn btn-outline-secondary mb-2">
                <i class="bi bi-arrow-90deg-left fs-6 me-2"></i> 回 上 一 頁</a>

              <label class="btn btn-danger chkoutBtn btn-chkout">
                <input type="submit" class="d-none">
                <i class="bi bi-basket-fill fs-3"></i> 確 定 結 帳
              </label>
            </div>
          </div>
        </form>

        <div class="text-center p-4">
          <a href="javascript:;" class="btn btn-secondary updatememBtn">
            加入個資送貨資訊 / 更新個資資訊
          </a>
        </div>


        <h3 class="mt-5"><i class="bi bi-truck"></i> 配送方式</h3>

        <div class="py-2 d-flex btn-list-send">
          <a href="javascript:;" class="btn btn-outline-secondary chkoutBtn">宅配到府</a>
          <a href="javascript:;" class="btn btn-outline-secondary chkoutBtn">7-11超商取貨</a>
          <a href="javascript:;" class="btn btn-outline-secondary chkoutBtn">全家超商取貨</a>
          <a href="javascript:;" class="btn btn-outline-secondary chkoutBtn">萊爾富超商取貨</a>
          <a href="javascript:;" class="btn btn-outline-secondary chkoutBtn">OK超商取貨</a>
        </div>

        <h3 class="mt-5"><i class="bi bi-cash-coin"></i> 付款方式</h3>

        <div class="py-2 d-flex justify-content-between align-items-stretch">
          <div class="d-flex align-items-stretch">
            <a href="javascript:;" class="btn chkoutBtn btn-card"><i class="bi bi-credit-card-2-back fs-3"></i> 信用卡</a>
            <a href="javascript:;" class="btn chkoutBtn btn-line"><img src="../img_layout/line.svg" height="30px" alt=""> LINE Pay</a>
            <a href="javascript:;" class="btn chkoutBtn btn-cash"><i class="bi bi-coin fs-3"></i> 貨到付款</a>
          </div>
        </div>

      </div>

    <h3 class="text-center text-danger">購物車沒有商品！</h3>
    
  </main>


  <?php include('../TS_webpage/footer.php'); ?>


  <script>
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
      return new bootstrap.Tooltip(tooltipTriggerEl)
    })


  </script>

</body>

</html>