
<div class="container-xl position-relative">

  <h1>修改新訊資料</h1>

  <form id="newsUpdateForm" method="post" action="" 
        class="shadow-lg rounded border border-secondary p-3 mb-4"
        enctype="multipart/form-data">
    <div class="row">

      <!-- 左側顯示上傳圖片 -->
      <div class="col-12 col-md-4 text-center">

        <!-- 以label標籤包含input標籤, 讓input標籤隱藏, 設計label標籤呈現視覺看到的樣子 -->
        <!-- 當按到label標籤時, 即代表了按到了input標籤(選擇檔案準備上傳檔案) -->
        <label class="btn btn-secondary cursor-p">

          <input type="file" name="news_img" id="news_img_m" class="d-none"
            accept=".jpg,.jpeg,.png,.gif" class="d-none">

          <i class="bi bi-image"></i> 上傳圖片 
        </label>

        <br><small>請選擇寬度大於 1000px，<br>
              容量小於 1M 的 jpg / png / gif 圖片</small>

        <!-- #imgErrMsg 這個區域負責顯示選擇圖的錯誤訊息 -->
        <div id="imgErrMsg_m" style="color:red;font-weight:bold"></div>

        <!--#imgArea 這個區域負責顯示所選擇的圖檔, 也就是影像的預覽區域 -->
        <div class="p-3">
          <img src="../img_layout/pre_img_news.png" id="imgArea_m" class="d-block img-fluid imgArea" alt="">
        </div>

      </div>

      <!-- 右側顯示其他欄位 -->
      <div class="col-12 col-md-8 col-right">

        <!-- 這裡是下拉式選單選擇新訊分類 -->
        <div class="d-flex align-items-center">
          <div class="col-icon"><i class="bi bi-folder-fill"></i></div>
          <div class="flex-fill select_news_class">

            <select name="class_news_id" class="form-select" required>
              <option value="" disabled selected>選擇新訊的分類...</option>

              
              <option value="">
                
              </option>
              

            </select>
          </div>
        </div>

        <!-- 這裡是新訊標題欄位 -->
        <div class="d-flex align-items-center">
          <div class="col-icon"><i class="bi bi-flag-fill"></i></div>
          <div class="flex-fill">
            <input type="text" name="news_title" maxlength="30" class="form-control" placeholder="輸入新訊的標題" required value="">
          </div>
        </div>

        <!-- 這裡是新訊內容欄位 -->
        <div class="d-flex align-items-top mt-3">
          <div class="col-icon"><i class="bi bi-chat-left-text-fill"></i></div>
          <div class="flex-fill">
            <div>
              PS. 如需插圖，前往 
              <a href="" target="_blank" class="btn btn-sm btn-outline-dark" style="transform: translateY(-3px);">選擇圖片</a>，
              游標停在要置入位置，按【<span class="text-danger">插入圖像</span>】按鈕=>【<span class="text-danger">URL</span>】=>【<span class="text-danger">貼上</span>】！<br>
              PS. 如需影片=>YouTube=>分享=>「&lt;/&gt;」=>複製=>按【<span class="text-danger">原始碼</span>】按鈕=>【<span class="text-danger">貼上</span>】！
            </div>
            <textarea name="news_content2" id="news_content2" class="form-control" rows="10" placeholder="輸入新訊的內容" required></textarea>
          </div>
        </div>
        
        <!-- 這裡是設計是否為網站前台顯示, 是否網站首頁顯示, 是否新訊首頁顯示 -->
        <div class="d-flex align-items-center">
          <div class="col-icon"><i class="bi bi-geo-alt-fill"></i></div>
          <div class="flex-fill d-flex justify-content-between">

            <div>
              <label class="cursor-p">
                <input type="radio" name="news_show" class="form-check-input" value="1">是上架顯示</label>

              <label class="cursor-p ms-2">
                <input type="radio" name="news_show" class="form-check-input" value="0">不上架不顯示</label>
            </div>

            <div class="w3-right">
              <label class="cursor-p">
                <input type="checkbox" name="news_show_index" class="form-check-input" value="1"> 網站首頁顯示
              </label>
              <label class="cursor-p ms-2">
                <input type="checkbox" name="news_show_news" class="form-check-input" value="1"> news首頁顯示
              </label>
            </div>

          </div>
        </div>

      </div>

      <!-- 表單下方按鈕區域 -->
      <div class="col-12 form-btn-area mt-3 d-flex">
        <input type="submit" class="btn btn-secondary d-block w-100" value="確定更新新訊">
      </div>

    </div>

    <input type="hidden" name="news_id" value="">
    <input type="hidden" name="MM_process" value="update">
  </form>

</div>






<script>
  //如果有上傳檔案
  $('#news_img_m').on('change', function() {
    //設定變數, 設定條件
    uploadErrMsg = document.querySelector('#imgErrMsg_m');  //error msg 的 div
    imgPreArea = document.querySelector('#imgArea_m');      //preview img
    console.log(this.files[0]);
    upload_chk_img(this.files[0], maxSize, minWidth, imgPreArea, uploadErrMsg);
  });

  //判斷表單是否能送出
  $('#newsUpdateForm').on('submit', function() {
    if (issubmit) {
      return true;
    } else {
      return false;
    }
  });
</script>


<script>
  CKEDITOR.replace('news_content2',{
    extraPlugins: "codesnippet",
    codeSnippet_theme: "solarized_dark",
    toolbar: [
      { name: 'styles', items: ['Format', 'FontSize'] },
      { name: 'colors', items: ['TextColor', 'BGColor'] },
      { name: 'basicstyles', items: ['Bold', 'Italic', 'Underline', '-', 'CopyFormatting', 'RemoveFormat'] },
      { name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'] },
      '/',
      { name: 'insert', items: ['Blockquote', '-', 'Image', 'Iframe', 'Link', 'Table', 'HorizontalRule'] },
      { name: 'document', items: ['Source', 'Maximize'] }
    ]
  });
</script>