
<!DOCTYPE html>
<html lang="zh-Hant-TW">

<head>
  <?php include('./head.php'); ?>
</head>

<body class="news" data-no="0">

  <?php include('./header.php'); ?>

  <main>
    <div class="container-xl position-relative">

      <button id="showNewsInsertForm" class="btn btn-danger position-absolute start-0 top-0">顯示/隱藏新增表單</button>

      <h1>新訊管理中心</h1>

      <!-- 新增新訊的表單 =========================== -->
      <form id="newsInsertForm" method="post" action="" 
      class="shadow-lg rounded border border-secondary p-3 mb-4 d-none">
        <div class="row">

          <!-- 左側顯示上傳圖片 ============== -->
          <div class="col-12 col-md-4 text-center">

            <!-- 以label標籤包含input標籤, 讓input標籤隱藏, 設計label標籤呈現視覺看到的樣子 -->
            <!-- 當按到label標籤時, 即代表了按到了input標籤(選擇檔案準備上傳檔案) -->
            <label class="btn btn-secondary cursor-p">

              <input type="file" name="news_img" id="news_img" accept=".jpg,.jpeg,.png,.gif" class="d-none">

              <i class="bi bi-image"></i> 上傳圖片
            </label>

            <br><small>請選擇寬度大於 1000px，<br>
              容量小於 1M 的 jpg / png / gif 圖片</small>

            <!-- #imgErrMsg 這個區域負責顯示選擇圖的錯誤訊息 -->
            <div id="imgErrMsg" style="color:red;font-weight:bold"></div>

            <!--#imgArea 這個區域負責顯示所選擇的圖檔, 也就是影像的預覽區域 -->
            <div class="p-3">
              <img id="imgArea" class="imgArea d-block img-fluid">
            </div>

          </div>

          <!-- 右側顯示其他欄位 ============== -->
          <div class="col-12 col-md-8 col-right">
            
            <!-- 這裡是下拉式選單選擇新訊分類 -->
            <div class="d-flex align-items-center">
              <div class="col-icon"><i class="bi bi-folder-fill"></i></div>
              <div class="flex-fill select_news_class">

                <select name="class_news_id" class="form-select" required>
                  <option value="" disabled selected>選擇新訊的分類...</option>

                  
                  <option value="">
                    
                  </option>

                </select>

              </div>
            </div>

            <!-- 這裡是新訊標題欄位 -->
            <div class="d-flex align-items-center">
              <div class="col-icon"><i class="bi bi-flag-fill"></i></div>
              <div class="flex-fill">
                <input type="text" name="news_title" maxlength="30" class="form-control" placeholder="輸入新訊的標題" required>
              </div>
            </div>

            <!-- 這裡是新訊內容欄位 -->
            <div class="d-flex align-items-top mt-3">
              <div class="col-icon"><i class="bi bi-chat-left-text-fill"></i></div>
              <div class="flex-fill">
                <div>
                PS. 如需插圖，前往 
                <a href="" target="_blank" class="btn btn-sm btn-outline-dark" style="transform: translateY(-3px);">選擇圖片</a>，
                游標停在要置入位置，按【<span class="text-danger">插入圖像</span>】按鈕=>【<span class="text-danger">URL</span>】=>【<span class="text-danger">貼上</span>】！<br>
                PS. 如需影片=>YouTube=>分享=>「&lt;/&gt;」=>複製=>按【<span class="text-danger">原始碼</span>】按鈕=>【<span class="text-danger">貼上</span>】！
                </div>
                <textarea name="news_content" id="news_content" class="form-control" rows="5" placeholder="輸入新訊的內容" required></textarea>
              </div>
            </div>

            <!-- 這裡是設計是否為網站前台顯示, 是否網站首頁顯示, 是否新訊首頁顯示 -->
            <div class="d-flex align-items-center">
              <div class="col-icon"><i class="bi bi-geo-alt-fill"></i></div>
              <div class="flex-fill d-flex justify-content-between">

                <div>
                  <label class="cursor-p">
                    <input type="radio" name="news_show" class="form-check-input" value="1" checked>
                    是上架顯示</label>

                  <label class="cursor-p ms-2">
                    <input type="radio" name="news_show" class="form-check-input" value="0">
                    不上架不顯示</label>
                </div>

                <div class="w3-right">
                  <label class="cursor-p">
                    <input type="checkbox" name="news_show_index" class="form-check-input" value="1" checked> 網站首頁顯示
                  </label>
                  <label class="cursor-p ms-2">
                    <input type="checkbox" name="news_show_news" class="form-check-input" value="1" checked> 新訊首頁顯示
                  </label>
                </div>

              </div>
            </div>

          </div>

          <!-- 表單下方按鈕區域 -->
          <div class="col-12 form-btn-area">
            <input type="submit" class="btn btn-secondary d-block w-100" value="確定新增">
          </div>

        </div>
        <input type="hidden" name="MM_process" value="insert">
      </form>


      <div class="d-flex align-items-center justify-content-between">
        <p>-----
          
          的新訊 有  篇 -----</p>
        <!-- 關鍵字搜尋表單準備區 -->
        <form method="get" action="" class="w3-right d-flex pb-2">
          <input type="text" name="search_keyword" class="form-control" style="width:22em" placeholder="新訊關鍵字, 不輸入按「搜尋」則顯示全部...">
          <input type="submit" class="btn btn-outline-dark" value="搜尋">
        </form>
      </div>


      <div class="table-responsive">
        <table class="table">
          <tbody>
            <tr>
              <th width="150" class="text-center">功能</th>
              <th width="80" class="text-center">分類</th>
              <th>[ID]標題</th>
              <th width="50" class="text-center">前台顯示</th>
              <th width="50" class="text-center">首頁顯示</th>
              <th width="50" class="text-center">新訊首頁</th>
              <th>建檔時間</th>
              <th>修改時間</th>
              <th width="90" class="text-center">縮圖</th>
              <th>建檔人員</th>
            </tr>

            

            <tr>
              <!-- 第1格：功能 -->
              <td class="text-center">

                <a href="" class="btn btn-outline-warning process-btn" data-bs-toggle="modal" data-bs-target="#process-modal">修改</a>

                <a href="" class="btn btn-outline-secondary process-btn" data-bs-toggle="modal" data-bs-target="#process-modal">刪除</a>
              </td>

              <!-- 第2格：分類 -->
              <td class="text-center">
                
              </td>

              <!-- 第3格：[ID]標題 -->
              <td>
                <div class="d-flex align-items-center">
                  [news_id]
                  <a href="" class="btn btn-outline-info text-black d-inline-block wordhidden text-start process-btn" style="width: 360px;">
                  
                  </a>
                </div>
              </td>

              <!-- 第4格：前台顯示 -->
              <td class="text-center">
                
              </td>

              <!-- 第5格：首頁顯示 -->
              <td class="text-center">
                
              </td>

              <!-- 第6格：新訊首頁 -->
              <td class="text-center">
                
              </td>

              <!-- 第7格：建檔時間 -->
              <td></td>

              <!-- 第8格：修改時間 -->
              <td></td>

              <!-- 第9格：顯示縮圖 -->
              <td class="text-center">
                
                <img src="../img_layout/pre_img_news.png" height="50" alt="">

              </td>

              <!-- 第10格：建檔人員 -->
              <td>
                
              </td>
            </tr>

            
          </tbody>
        </table>
      </div>

      <!-- 頁碼導覽列 -->
      

      <!-- Button trigger modal -->
      <button type="button" class="btn btn-primary d-none" data-bs-toggle="modal" data-bs-target="#process-modal">
        Show Modal
      </button>

      <!-- Modal -->
      <div class="modal fade" id="process-modal" tabindex="-1" aria-labelledby="process-modal-label" aria-hidden="true">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header border-0">
              <h5 class="modal-title" id="process-modal-label"></h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body content">
              ...
            </div>
          </div>
        </div>
      </div>

    </div>
  </main>





  <script>
    //切換是否show新增表單===============================
    let obj_form = $('#newsInsertForm');
    $('#showNewsInsertForm').on('click', function(){
      if( obj_form.hasClass('d-none') ){
        obj_form.removeClass('d-none');
      }else{
        obj_form.addClass('d-none');
      }
    });


  </script>



</body>

</html>